ORCA/M Asm65816 2.1.0

0001 D400              ;==========================================================
0002 D400              ;
0003 D400              ;  file init.4
0004 D400              ;
0005 D400              ;  Contains miscellaneous procedures used by the Init Mgr.
0006 D400              ;
0007 D400              ;  Copyright (C) 1988-1992 Apple Computer, Inc.
0008 D400              ;  All Rights Reserved.
0009 D400              ;
0010 D400              ;==========================================================
0011 D400
0012 D400                       eject 
0013 D400              ;==========================================================
0014 D400              ;
0015 D400              ;  add_size_str
0016 D400              ;
0017 D400              ;  Convert the size given at init_temp_2 into ascii, then
0018 D400              ;  append it to the string pointed to by init_temp_1.
0019 D400              ;
0020 D400              ;  Inputs:      init_temp_1 = p-string pointer
0021 D400              ;               init_temp_2 = long # to convert
0022 D400              ;
0023 D400              ;  Outputs:     A = trashed
0024 D400              ;               X = trashed
0025 D400              ;               Y = trashed
0026 D400              ;               P = nvmxdizc
0027 D400              ;                   ..000...
0028 D400              ;
0029 D400              ;==========================================================
0030 D400
0031 D400              add_size_str Proc 
0032 D400                       Import dest_buffer
0033 D400
0034 D400                       with my_direct_page
0035 D400
0036 D400 D4 B0                 pei   <init_temp_2+2           ; value to convert
0037 D402 D4 AE                 pei   <init_temp_2
0038 D404 F4 01 00              pea   dest_buffer>>16          ; where to put it
0039 D407 F4 34 D0              pea   dest_buffer
0040 D40A F4 10 00              pea   dest_length              ; how much space
0041 D40D F4 00 00              pea   0                        ; unsigned input
0042 D410 A2 0B 27              ldx   #$270B                   ; long2dec
0043 D413 22 00 00 E1           jsl   $E10000
0044 D417
0045 D417 A2 FF FF              ldx   #-1                      ; find start of actual str
0046 D41A E2 20                 sep   #$20                     ; 8-bit acc
0047 D41C                       longa off
0048 D41C A9 20                 lda   #' '                     ; skip spaces
0049 D41E
0050 D41E              add_size_1  
0051 D41E E8                    inx                            ; bump index
0052 D41F DD 34 D0              cmp   dest_buffer,X            ; a space?
0053 D422 F0 FA                 beq   add_size_1               ; yes, skip it
0054 D424
0055 D424              add_size_2  
0056 D424 CA                    dex                            ; adjust string pointer
0057 D425 DA                    phx                            ; (pushes 2 bytes)
0058 D426 18                    clc                            ; calculate length of string
0059 D427 A9 10                 lda   #dest_length             ; byte
0060 D429 E3 01                 sbc   1,s                      ; byte
0061 D42B
0062 D42B 9D 34 D0              sta   dest_buffer,X            ; insert length byte
0063 D42E
0064 D42E C2 20                 rep   #$20                     ; 16 bit acc
0065 D430                       longa on
0066 D430
0067 D430 68                    pla                            ; clean stack
0068 D431 8A                    txa                            ; get offset
0069 D432 18                    clc   
0070 D433 69 34 D0              adc   #<dest_buffer
0071 D436 AA                    tax   
0072 D437 A9 00 00              lda   #0
0073 D43A 69 01 00              adc   #^dest_buffer
0074 D43D A8                    tay   
0075 D43E              ;	fall through to add_string
0076 D43E
0077 D43E                       eject 
0078 D43E              ;==========================================================
0079 D43E              ;
0080 D43E              ;  add_string
0081 D43E              ;
0082 D43E              ;  Append the string pointed to by X and Y to the string
0083 D43E              ;  pointed to by init_temp_1.
0084 D43E              ;
0085 D43E              ;
0086 D43E              ;  Inputs:      X,Y = p-string source pointer
0087 D43E              ;               init_temp_1 = p-string dest pointer
0088 D43E              ;
0089 D43E              ;  Outputs:     A = trashed
0090 D43E              ;               X = trashed
0091 D43E              ;               Y = trashed
0092 D43E              ;               P = nvmxdizc
0093 D43E              ;                   ..000...
0094 D43E              ;
0095 D43E              ;==========================================================
0096 D43E
0097 D43E                       entry add_string
0098 D43E 86 AE        add_string stx   <init_temp_2
0099 D440 84 B0                 sty   <init_temp_2+2
0100 D442
0101 D442 A9 01 00              lda   #1                       ; source offset
0102 D445 85 B2                 sta   <init_temp_3
0103 D447 A7 AA                 lda   [<init_temp_1]           ; dest offset
0104 D449 1A                    inc   a
0105 D44A 29 FF 00              and   #$00FF
0106 D44D 85 B4                 sta   <init_temp_3+2
0107 D44F 3A                    dec   a                        ; fix for length comp
0108 D450 18                    clc   
0109 D451 67 AE                 adc   [<init_temp_2]           ; compute new length
0110 D453
0111 D453 E2 30                 sep   #$30                     ; 8 bit acc + index
0112 D455                       longa off
0113 D455                       longi off
0114 D455
0115 D455 87 AA                 sta   [<init_temp_1]           ; store new length
0116 D457
0117 D457 A7 AE                 lda   [<init_temp_2]           ; src len is xfer ct
0118 D459 AA                    tax   
0119 D45A
0120 D45A              add_string_1  
0121 D45A A4 B2                 ldy   <init_temp_3             ; src offset
0122 D45C B7 AE                 lda   [<init_temp_2],y
0123 D45E A4 B4                 ldy   <init_temp_3+2           ; dest offset
0124 D460 97 AA                 sta   [<init_temp_1],y
0125 D462
0126 D462 E6 B2                 inc   <init_temp_3             ; 8 bit inc but thats ok
0127 D464 E6 B4                 inc   <init_temp_3+2
0128 D466
0129 D466 CA                    dex                            ; xfer counter
0130 D467 D0 F1                 bne   add_string_1
0131 D469
0132 D469 C2 30                 rep   #$30                     ; 16 bit acc + index
0133 D46B                       longa on
0134 D46B                       longi on
0135 D46B
0136 D46B 60                    rts   
0137 D46C
0138 D46C                       EndP 
0139 D46C
0140 D46C                       eject 
0141 D46C              ;==========================================================
0142 D46C              ;
0143 D46C              ;  make_fmt_str
0144 D46C              ;
0145 D46C              ;  This takes the info found in a device format record
0146 D46C              ;  and creates a descriptive string.  The string has the
0147 D46C              ;  following format:
0148 D46C              ;
0149 D46C              ;  nnn k  mm:1
0150 D46C              ;
0151 D46C              ;  The size figure always appears ;  the interleave factor
0152 D46C              ;  only appears when valid ( != 0 ).
0153 D46C              ;
0154 D46C
0155 D46C              ;  The size figure is repeated as specified by a format
0156 D46C              ;  options list ;  or it is calculated if there is only
0157 D46C              ;  a single, DIB-synthesized option.
0158 D46C              ;
0159 D46C              ;  input:       A = entry number to calculate with
0160 D46C              ;
0161 D46C              ;  output:      df_string = VP of a p-string
0162 D46C              ;               A = trashed
0163 D46C              ;               X = trashed
0164 D46C              ;               Y = trashed
0165 D46C              ;               P = nvmxdizc
0166 D46C              ;                   ..000...
0167 D46C              ;
0168 D46C              ;  This routine may move memory.
0169 D46C              ;
0170 D46C              ;==========================================================
0171 D46C
0172 D46C              make_fmt_str Proc 
0173 D46C                       Import colon_one,two_spaces,fmt_str_tb,dot_five,jsl_fmt_ptr
0174 D46C                       Import which_call
0175 D46C
0176 D46C                       with my_direct_page,fmt_list_record
0177 D46C
0178 D46C 48                    pha                            ; remember my victim
0179 D46D
0180 D46D A9 10 00              lda   #16                      ; make it 16 bytes
0181 D470 38                    sec   
0182 D471 22 00 D4 00           jsl   call_alloc
0183 D475 86 AE                 stx   <init_temp_2
0184 D477 84 B0                 sty   <init_temp_2+2
0185 D479
0186 D479 A6 80                 ldx   <fmt_list_vp             ; call_deref fmt list only
0187 D47B A4 82                 ldy   <fmt_list_vp+2           ; (fst_list not around yet!)
0188 D47D 22 08 D4 00           jsl   call_deref
0189 D481 86 84                 stx   <fmt_list_ptr
0190 D483 84 86                 sty   <fmt_list_ptr+2
0191 D485
0192 D485 68                    pla   
0193 D486 22 73 D4 00           jsl   jsl_fmt_ptr
0194 D48A
0195 D48A A6 AE                 ldx   <init_temp_2
0196 D48C A4 B0                 ldy   <init_temp_2+2
0197 D48E 22 08 D4 00           jsl   call_deref
0198 D492 86 AA                 stx   <init_temp_1
0199 D494 84 AC                 sty   <init_temp_1+2
0200 D496
0201 D496 A0 0A 00              ldy   #df_string               ; install string vp
0202 D499 A5 AE                 lda   <init_temp_2
0203 D49B 97 88                 sta   [<fmt_list_entry],y
0204 D49D C8                    iny   
0205 D49E C8                    iny   
0206 D49F A5 B0                 lda   <init_temp_2+2
0207 D4A1 97 88                 sta   [<fmt_list_entry],y
0208 D4A3
0209 D4A3              ;  If we have a size figure, use it.
0210 D4A3
0211 D4A3 A0 1C 00              ldy   #df_fmt_size
0212 D4A6 B7 88                 lda   [<fmt_list_entry],y
0213 D4A8 F0 12                 beq   make_fmt_str_1
0214 D4AA
0215 D4AA 85 AE                 sta   <init_temp_2             ; this is the number to use
0216 D4AC 64 B0                 stz   <init_temp_2+2           ; its only a word
0217 D4AE
0218 D4AE 20 00 D4              jsr   add_size_str             ; convert and insert
0219 D4B1
0220 D4B1 A0 12 00              ldy   #df_flags                ; what are the units?
0221 D4B4 B7 88                 lda   [<fmt_list_entry],y
0222 D4B6
0223 D4B6 29 0C 00              and   #$000C                   ; bits 2 and 3, times 4
0224 D4B9 AA                    tax   
0225 D4BA
0226 D4BA 80 43                 bra   make_fmt_str_4           ; add units and interleave
0227 D4BC
0228 D4BC              ;  no size figure given.  Calculate from dib.  If >5 Mb, use Mb,
0229 D4BC              ;  otherwise display as # of k.
0230 D4BC
0231 D4BC              make_fmt_str_1  
0232 D4BC A0 16 00              ldy   #df_block_ct+2           ; divide block ct by 2
0233 D4BF B7 88                 lda   [<fmt_list_entry],y
0234 D4C1 4A                    lsr   a                        ; to get #k
0235 D4C2 AA                    tax                            ; (remember hi wd for a moment)
0236 D4C3 88                    dey   
0237 D4C4 88                    dey   
0238 D4C5 B7 88                 lda   [<fmt_list_entry],y
0239 D4C7 6A                    ror   a
0240 D4C8
0241 D4C8              ;  If the just-rolled-out bit is 1, the fractional size is > 0.5 k.
0242 D4C8              ;  So, in that case we round up.
0243 D4C8
0244 D4C8 90 04                 bcc   rnd_str_1
0245 D4CA 1A                    inc   a
0246 D4CB D0 01                 bne   rnd_str_1                ; incrementing a long
0247 D4CD E8                    inx   
0248 D4CE
0249 D4CE              rnd_str_1  
0250 D4CE 85 AE                 sta   <init_temp_2
0251 D4D0 86 B0                 stx   <init_temp_2+2
0252 D4D2
0253 D4D2              ;  If the size is too big for K's, display Mb's.
0254 D4D2
0255 D4D2 9B                    txy                            ; >64 mb?
0256 D4D3 D0 0D                 bne   make_fmt_str_2
0257 D4D5 C9 00 14              cmp   #$1400                   ; >5 Mb?
0258 D4D8 B0 08                 bge   make_fmt_str_2
0259 D4DA
0260 D4DA 20 00 D4              jsr   add_size_str             ; its k.  add the string
0261 D4DD A2 04 00              ldx   #4
0262 D4E0 80 1D                 bra   make_fmt_str_4
0263 D4E2
0264 D4E2              ;  generated string, >5 meg.  convert to megs.
0265 D4E2
0266 D4E2              make_fmt_str_2  
0267 D4E2 A2 0A 00              ldx   #10                      ; divide by 2^10
0268 D4E5              make_fmt_str_3  
0269 D4E5 46 B0                 lsr   <init_temp_2+2
0270 D4E7 66 AE                 ror   <init_temp_2
0271 D4E9 CA                    dex   
0272 D4EA D0 F9                 bne   make_fmt_str_3
0273 D4EC
0274 D4EC 08                    php                            ; save carry status from last "ror"
0275 D4ED 20 00 D4              jsr   add_size_str             ; Now megs.  add the string
0276 D4F0 28                    plp                            ; retrieve carry status
0277 D4F1 90 09                 bcc   no_dot_five              ; if carry is set we need to add a ".5"
0278 D4F3 A2 39 D2              ldx   #<dot_five               ; get address of the string
0279 D4F6 A0 01 00              ldy   #^dot_five
0280 D4F9 20 3E D4              jsr   add_string               ; and add it
0281 D4FC              no_dot_five  
0282 D4FC A2 08 00              ldx   #8
0283 D4FF
0284 D4FF              ;  add the units string indexed by X
0285 D4FF
0286 D4FF              make_fmt_str_4  
0287 D4FF BD 3E D2              lda   fmt_str_tb+2,X           ; make ptr to add string
0288 D502 A8                    tay   
0289 D503 BD 3C D2              lda   fmt_str_tb,X
0290 D506 AA                    tax   
0291 D507
0292 D507 20 3E D4              jsr   add_string               ; stick it on
0293 D50A
0294 D50A              ;  now add the interleave, if necessary
0295 D50A
0296 D50A AD 02 D0              lda   |which_call              ; if Erase call - don't add interleave
0297 D50D D0 22                 bne   make_fmt_str_5
0298 D50F
0299 D50F A0 1A 00              ldy   #df_interleave
0300 D512 B7 88                 lda   [<fmt_list_entry],y
0301 D514 F0 1B                 beq   make_fmt_str_5           ; if zero, N/A
0302 D516 48                    pha   
0303 D517
0304 D517 A2 33 D2              ldx   #<two_spaces
0305 D51A A0 01 00              ldy   #^two_spaces
0306 D51D 20 3E D4              jsr   add_string
0307 D520
0308 D520 68                    pla   
0309 D521 85 AE                 sta   <init_temp_2             ; add interleave value
0310 D523 64 B0                 stz   <init_temp_2+2
0311 D525 20 00 D4              jsr   add_size_str
0312 D528
0313 D528 A2 36 D2              ldx   #<colon_one
0314 D52B A0 01 00              ldy   #^colon_one
0315 D52E 20 3E D4              jsr   add_string
0316 D531
0317 D531              make_fmt_str_5  
0318 D531 60                    rts   
0319 D532                       EndP 
0320 D532
0321 D532                       eject 
0322 D532              ;==========================================================
0323 D532              ;
0324 D532              ;  query_driver
0325 D532              ;
0326 D532              ;  Calls the specified driver with a request for formatting
0327 D532              ;  options.  If none are available, assume a single format
0328 D532              ;  option and get info from the DIB.  Build a data structure
0329 D532              ;  based on the formatting options found.
0330 D532              ;
0331 D532              ;  Inputs:      dev_num = requested device
0332 D532              ;
0333 D532              ;  Outputs:     fmt_list_vp = VP of the new structure
0334 D532              ;               fmt_disp_cnt = number of entries therein
0335 D532              ;               fmt_def_fmt = driver specified default
0336 D532              ;               fmt_cur_med = currently installed media's fmt #
0337 D532              ;               A = if C == 1, contains error #
0338 D532              ;               X = trashed
0339 D532              ;               Y = trashed
0340 D532              ;               P = nvmxdizc
0341 D532              ;                   ..000..|
0342 D532              ;                          0=no error, 1=device not formattable
0343 D532              ;
0344 D532              ;  This routine may move memory.
0345 D532              ;
0346 D532              ;==========================================================
0347 D532
0348 D532              query_driver Proc Export
0349 D532                       Import cp8_t2x_t3y
0350 D532                       Import which_call
0351 D532
0352 D532                       with my_direct_page,fmt_list_record
0353 D532
0354 D532              ;  setup.  allocate a buffer for the status lists
0355 D532
0356 D532 A9 00 01              lda   #256                     ;start out with 256 byte buffer
0357 D535 48                    pha   
0358 D536
0359 D536              get_slist_buf                           ;buffer size is in A register
0360 D536 22 00 D4 00           jsl   call_alloc               ;allocate the buffer
0361 D53A 86 AA                 stx   <init_temp_1
0362 D53C 84 AC                 sty   <init_temp_1+2
0363 D53E 22 08 D4 00           jsl   call_deref
0364 D542 86 AE                 stx   <init_temp_2
0365 D544 84 B0                 sty   <init_temp_2+2
0366 D546
0367 D546              ;  step 1:  get_dib_ptr and see if this guy can format
0368 D546
0369 D546 64 00                 stz   <drvr_dev_num
0370 D548 A9 01 00              lda   #get_dib_ptr
0371 D54B 85 02                 sta   <drvr_call_num
0372 D54D A5 36                 lda   <dev_num
0373 D54F 85 04                 sta   <drvr_buf_ptr
0374 D551 22 18 D4 00           jsl   call_dispatch
0375 D555 B0 49                 bcs   query_drv_err
0376 D557
0377 D557 A0 08 00              ldy   #8                       ; characteristics word
0378 D55A B7 20                 lda   [<drvr_dib_ptr],y
0379 D55C 89 80 00              bit   #$0080                   ; character device?
0380 D55F D0 05                 bne   query_drv_a
0381 D561 A9 58 00              lda   #not_block_dev
0382 D564 80 3A                 bra   query_drv_err
0383 D566
0384 D566              query_drv_a  
0385 D566 89 40 00              bit   #%0000000001000000       ; write allowed?
0386 D569              ** 28 Feb 92  GAB
0387 D569              ** ProFile lies about its ability to accept a format call
0388 D569                                                      ;beq	@no_write	; no, so obviously can't format
0389 D569                                                      ;bit	#%0000000000001000	; formatting allowed?
0390 D569              **
0391 D569 D0 05                 bne   query_drv_0              ; yes, we can use it
0392 D56B              @no_write  
0393 D56B A9 2B 00              lda   #drvr_wr_prot
0394 D56E 80 30                 bra   query_drv_err
0395 D570
0396 D570              ;  step 2:  ask the driver for formatting info
0397 D570              ;           for a Format call do Get_Format_Options
0398 D570              ;           for an Erase call do Get_Device_Status
0399 D570
0400 D570              query_drv_0  
0401 D570 A5 36                 lda   <dev_num
0402 D572 85 00                 sta   <drvr_dev_num
0403 D574 A9 05 00              lda   #drvr_status
0404 D577 85 02                 sta   <drvr_call_num
0405 D579 A5 AE                 lda   <init_temp_2             ; dest ptr
0406 D57B 85 04                 sta   <drvr_slist_ptr
0407 D57D A5 B0                 lda   <init_temp_2+2
0408 D57F 85 06                 sta   <drvr_slist_ptr+2
0409 D581 64 0A                 stz   <drvr_req_cnt+2
0410 D583              ;	lda	|which_call
0411 D583              ;	bne	its_erase_call
0412 D583 A2 03 00              ldx   #$0003                   ; get_format_options
0413 D586 A3 01                 lda   1,s                      ; get buffer size
0414 D588              ;	bra	do_status_call
0415 D588              ;its_erase_call
0416 D588              ;	ldx	#0	; get_device_status
0417 D588              ;	lda	#6	; request count
0418 D588              do_status_call  
0419 D588 86 16                 stx   <drvr_ctrl_code
0420 D58A 85 08                 sta   <drvr_req_cnt
0421 D58C 22 18 D4 00           jsl   call_dispatch
0422 D590 B0 0E                 bcs   query_drv_err
0423 D592
0424 D592 AD 02 D0              lda   |which_call              ;if it's an Erase call
0425 D595 D0 23                 bne   query_drv_3a             ;skip the next part
0426 D597
0427 D597              ;  step 3:  based on the result, build a table of format options
0428 D597
0429 D597              step_3    
0430 D597 A5 0C                 lda   <drvr_tran_cnt           ; check return count
0431 D599 05 0E                 ora   <drvr_tran_cnt+2
0432 D59B F0 1D                 beq   query_drv_3a
0433 D59D 82 A9 00              brl   query_drv_3b
0434 D5A0
0435 D5A0              ;  we interrupt this program to bring you the error handler
0436 D5A0
0437 D5A0              query_drv_err  
0438 D5A0 48                    pha                            ;save error code
0439 D5A1 A6 AA                 ldx   <init_temp_1             ;dump the fmt data struct
0440 D5A3 A4 AC                 ldy   <init_temp_1+2
0441 D5A5 22 10 D4 00           jsl   call_release
0442 D5A9 68                    pla                            ;retrieve error code
0443 D5AA D0 0B                 bne   real_error               ;it was a real error
0444 D5AC 18                    clc                            ;buffer was too small so
0445 D5AD A3 01                 lda   1,s                      ;increase the requested size
0446 D5AF 69 00 01              adc   #256
0447 D5B2 83 01                 sta   1,s
0448 D5B4 82 7F FF              brl   get_slist_buf
0449 D5B7
0450 D5B7              real_error  
0451 D5B7 FA                    plx                            ;pull buffer size off stack
0452 D5B8 38                    sec   
0453 D5B9 6B                    rtl   
0454 D5BA
0455 D5BA              ;  step 3a:  no returned info.  simulate single entry using DIB info
0456 D5BA              ;
0457 D5BA              ;  mem_ptr      = set later
0458 D5BA              ;  mem_flag     = 0 (enabled, not selected)
0459 D5BA              ;  fill_byte    = 0
0460 D5BA              ;  refnum       = 0
0461 D5BA              ;  conf_num     = 1
0462 D5BA              ;  alias        = 0
0463 D5BA              ;  flags        = 0 (universal type) (set size units later)
0464 D5BA              ;  block_ct     = from DIB
0465 D5BA              ;  block_sz     = assume 512 bytes
0466 D5BA              ;  interleave   = 0 (means n/a)
0467 D5BA              ;  fmt_size     = set later
0468 D5BA              ;  one_fst      = set later
0469 D5BA              ;  string       = set later
0470 D5BA
0471 D5BA              query_drv_3a  
0472 D5BA A9 01 00              lda   #1                       ; one entry
0473 D5BD 85 8C                 sta   <fmt_disp_cnt
0474 D5BF 85 A0                 sta   <fmt_cur_med
0475 D5C1 85 9E                 sta   <fmt_def_fmt
0476 D5C3 85 8E                 sta   <fmt_total_cnt
0477 D5C5
0478 D5C5 A9 1E 00              lda   #df_size                 ; size of 1 entry
0479 D5C8 20 DC D6              jsr   get_fmt_mem
0480 D5CB
0481 D5CB A9 01 00              lda   #1                       ; driver conf. refnum = 1
0482 D5CE A0 0E 00              ldy   #df_conf_num
0483 D5D1 97 84                 sta   [<fmt_list_ptr],y
0484 D5D3
0485 D5D3 3A                    dec   a                        ; assume universal format
0486 D5D4 A0 12 00              ldy   #df_flags
0487 D5D7 97 84                 sta   [<fmt_list_ptr],y
0488 D5D9
0489 D5D9 A5 0C                 lda   <drvr_tran_cnt           ; were any format options returned?
0490 D5DB 05 0E                 ora   <drvr_tran_cnt+2
0491 D5DD F0 33                 beq   @no_fmt_options          ; no, leave format type as universal
0492 D5DF
0493 D5DF A0 06 00              ldy   #6                       ; get current option #
0494 D5E2 B7 AE                 lda   [<init_temp_2],y
0495 D5E4 D0 04                 bne   @got_option              ; if non-zero, use it
0496 D5E6 88                    dey   
0497 D5E7 88                    dey   
0498 D5E8 B7 AE                 lda   [<init_temp_2],y         ; else get the recommended option #
0499 D5EA              @got_option  
0500 D5EA 85 B2                 sta   <init_temp_3             ; save for comparisons
0501 D5EC A7 AE                 lda   [<init_temp_2]           ; get # of options
0502 D5EE 85 B4                 sta   <init_temp_3+2
0503 D5F0 A0 08 00              ldy   #8                       ; look at the first entry refnum
0504 D5F3              @loop     
0505 D5F3 B7 AE                 lda   [<init_temp_2],y
0506 D5F5 C5 B2                 cmp   <init_temp_3             ; is this the one we're looking for?
0507 D5F7 F0 0C                 beq   @use_this_entry          ; yes, use it's info
0508 D5F9 98                    tya                            ; else look at next option
0509 D5FA 18                    clc   
0510 D5FB 69 10 00              adc   #16                      ; entry size
0511 D5FE A8                    tay   
0512 D5FF C6 B4                 dec   <init_temp_3+2           ; have we looked at all options yet?
0513 D601 D0 F0                 bne   @loop                    ; no, try again
0514 D603 80 0D                 bra   @no_fmt_options          ; couldn't find it?????
0515 D605              @use_this_entry  
0516 D605 98                    tya                            ; offset to entry's flags word
0517 D606 18                    clc   
0518 D607 69 04 00              adc   #4                       ; add offset to first entry flags word
0519 D60A A8                    tay   
0520 D60B B7 AE                 lda   [<init_temp_2],y         ; get the flags word
0521 D60D A0 12 00              ldy   #df_flags
0522 D610 97 84                 sta   [<fmt_list_ptr],y        ; put into list record
0523 D612
0524 D612              @no_fmt_options  
0525 D612 7B                    tdc                            ; make a destination pointer
0526 D613 18                    clc   
0527 D614 69 B2 00              adc   #<init_temp_3            ; use init_temp_3 & init_temp_4
0528 D617 85 04                 sta   <drvr_slist_ptr          ; as the destination buffer
0529 D619 64 06                 stz   <drvr_slist_ptr+2        ; always in bank 0
0530 D61B 64 0A                 stz   <drvr_req_cnt+2
0531 D61D A2 00 00              ldx   #0                       ; get_device_status
0532 D620 A9 06 00              lda   #6                       ; request count
0533 D623 86 16                 stx   <drvr_ctrl_code          ; other parms left over from
0534 D625 85 08                 sta   <drvr_req_cnt            ;   get_format_options call
0535 D627 22 18 D4 00           jsl   call_dispatch
0536 D62B A0 04 00              ldy   #4                       ; block count from status call
0537 D62E B7 04                 lda   [<drvr_slist_ptr],y
0538 D630 AA                    tax   
0539 D631 88                    dey   
0540 D632 88                    dey   
0541 D633 B7 04                 lda   [<drvr_slist_ptr],y
0542 D635              cont_3a   
0543 D635 A0 14 00              ldy   #df_block_ct
0544 D638 97 84                 sta   [<fmt_list_ptr],y
0545 D63A C8                    iny   
0546 D63B C8                    iny   
0547 D63C 8A                    txa   
0548 D63D 97 84                 sta   [<fmt_list_ptr],y
0549 D63F
0550 D63F A9 00 02              lda   #512                     ; assume 512 byte blocks
0551 D642 C8                    iny   
0552 D643 C8                    iny   
0553 D644 97 84                 sta   [<fmt_list_ptr],y
0554 D646
0555 D646 82 7B 00              brl   query_drv_4
0556 D649
0557 D649              ;  step 3b:  use the returned data from the driver to build my list
0558 D649
0559 D649              query_drv_3b  
0560 D649 A7 AE                 lda   [<init_temp_2]           ;get # of entries in list
0561 D64B 0A                    asl   a
0562 D64C 0A                    asl   a
0563 D64D 0A                    asl   a
0564 D64E 0A                    asl   a                        ;multiply by 16
0565 D64F 69 08 00              adc   #8                       ;and add 8 to get total list size
0566 D652 C3 01                 cmp   1,s                      ;was our buffer large enough?
0567 D654 90 06                 bcc   cont_3b                  ;yes - so we got the whole list
0568 D656 A9 00 00              lda   #0                       ;no - so we need to get a bigger buffer
0569 D659 82 44 FF              brl   query_drv_err
0570 D65C
0571 D65C              cont_3b   
0572 D65C A7 AE                 lda   [<init_temp_2]           ; return options count
0573 D65E 85 8E                 sta   <fmt_total_cnt
0574 D660 AA                    tax   
0575 D661 A9 00 00              lda   #0
0576 D664
0577 D664              query_sz_lp  
0578 D664 69 1E 00              adc   #df_size                 ; calculate array size
0579 D667 CA                    dex   
0580 D668 D0 FA                 bne   query_sz_lp
0581 D66A
0582 D66A 20 DC D6              jsr   get_fmt_mem
0583 D66D 86 B2                 stx   <init_temp_3
0584 D66F 84 B4                 sty   <init_temp_3+2
0585 D671
0586 D671              ;  now walk through the returned list copying info
0587 D671
0588 D671 A0 02 00              ldy   #2
0589 D674 B7 AE                 lda   [<init_temp_2],y         ; # entries to display
0590 D676 85 8C                 sta   <fmt_disp_cnt
0591 D678 C8                    iny   
0592 D679 C8                    iny   
0593 D67A B7 AE                 lda   [<init_temp_2],y         ; default refnum
0594 D67C 85 9E                 sta   <fmt_def_fmt
0595 D67E C8                    iny   
0596 D67F C8                    iny   
0597 D680 B7 AE                 lda   [<init_temp_2],y         ; current media
0598 D682 85 A0                 sta   <fmt_cur_med
0599 D684
0600 D684 18                    clc                            ; set ptr to 1st entry
0601 D685 A5 AE                 lda   <init_temp_2
0602 D687 69 08 00              adc   #8
0603 D68A 85 AE                 sta   <init_temp_2
0604 D68C A5 B0                 lda   <init_temp_2+2
0605 D68E 69 00 00              adc   #0
0606 D691 85 B0                 sta   <init_temp_2+2
0607 D693
0608 D693 A2 00 00              ldx   #0                       ; x is entry counter
0609 D696 9B                    txy                            ; y is entry offset
0610 D697
0611 D697              copy_fmt_lp  
0612 D697 18                    clc                            ; move up 6 bytes into dest
0613 D698 A5 B2                 lda   <init_temp_3
0614 D69A 69 06 00              adc   #6                       ; (skipping mem_ptr, mem_flag,
0615 D69D 85 B2                 sta   <init_temp_3             ;  and fill_byte)
0616 D69F A5 B4                 lda   <init_temp_3+2
0617 D6A1 69 00 00              adc   #0
0618 D6A4 85 B4                 sta   <init_temp_3+2
0619 D6A6
0620 D6A6 8A                    txa                            ; write my refnum
0621 D6A7 97 B2                 sta   [<init_temp_3],y
0622 D6A9
0623 D6A9 18                    clc                            ; move up 8 bytes into dest
0624 D6AA A5 B2                 lda   <init_temp_3
0625 D6AC 69 08 00              adc   #8                       ; (skipping over my refnum,
0626 D6AF 85 B2                 sta   <init_temp_3             ;  one_fst, and string vp)
0627 D6B1 A5 B4                 lda   <init_temp_3+2
0628 D6B3 69 00 00              adc   #0
0629 D6B6 85 B4                 sta   <init_temp_3+2
0630 D6B8
0631 D6B8 DA                    phx   
0632 D6B9 BB                    tyx   
0633 D6BA 22 93 B2 00           jsl   cp8_t2x_t3y              ; copy 8 words
0634 D6BE              ;                                       ; (conf num, alias, flags, block
0635 D6BE              ;                                       ;  count, block size, interleave,
0636 D6BE              ;                                       ;  format size)
0637 D6BE
0638 D6BE FA                    plx   
0639 D6BF E8                    inx   
0640 D6C0 E4 8E                 cpx   <fmt_total_cnt           ; done?
0641 D6C2 D0 D3                 bne   copy_fmt_lp
0642 D6C4
0643 D6C4              ;  step #4: clean up that mess
0644 D6C4
0645 D6C4              query_drv_4  
0646 D6C4 A6 AA                 ldx   <init_temp_1
0647 D6C6 A4 AC                 ldy   <init_temp_1+2
0648 D6C8 22 10 D4 00           jsl   call_release
0649 D6CC
0650 D6CC              ;  step #5: create a string for each entry
0651 D6CC
0652 D6CC A9 00 00              lda   #0
0653 D6CF
0654 D6CF              query_drv_5_lp  
0655 D6CF 48                    pha   
0656 D6D0 20 6C D4              jsr   make_fmt_str
0657 D6D3 68                    pla   
0658 D6D4
0659 D6D4 1A                    inc   a
0660 D6D5 C5 8C                 cmp   <fmt_disp_cnt
0661 D6D7 D0 F6                 bne   query_drv_5_lp
0662 D6D9
0663 D6D9              ;  step #6:  escape while there's time.
0664 D6D9
0665 D6D9 FA                    plx                            ;pull buffer size off stack
0666 D6DA 18                    clc   
0667 D6DB 6B                    rtl   
0668 D6DC
0669 D6DC              ; This subroutine simply calls alloc_seg for the fmt list memory
0670 D6DC
0671 D6DC              get_fmt_mem  
0672 D6DC 38                    sec                            ; cleared, please!
0673 D6DD 22 00 D4 00           jsl   call_alloc
0674 D6E1 86 80                 stx   <fmt_list_vp
0675 D6E3 84 82                 sty   <fmt_list_vp+2
0676 D6E5 22 08 D4 00           jsl   call_deref
0677 D6E9 86 84                 stx   <fmt_list_ptr
0678 D6EB 84 86                 sty   <fmt_list_ptr+2
0679 D6ED 60                    rts   
0680 D6EE                       EndP 
0681 D6EE
0682 D6EE                       eject 
0683 D6EE              ;==========================================================
0684 D6EE              ;
0685 D6EE              ;  jsl fst_scan
0686 D6EE              ;
0687 D6EE              ;  Examine each on-line FST.  For each which supports
0688 D6EE              ;  formatting, build an entry in a table at fst_list_vp.
0689 D6EE              ;  Here because it directly references fst_tbl_data.
0690 D6EE              ;
0691 D6EE              ;  Outputs:     fst_list_vp = VP of new data structure
0692 D6EE              ;               fst_list_cnt = number of entries therein
0693 D6EE              ;               A = error number if C == 1
0694 D6EE              ;               X = trashed
0695 D6EE              ;               Y = trashed
0696 D6EE              ;               P = nvmxdizc
0697 D6EE              ;                   ..000..|
0698 D6EE              ;                          0=no error, 1=no FST's available
0699 D6EE              ;
0700 D6EE              ;  This routine may move memory.
0701 D6EE              ;
0702 D6EE              ;==========================================================
0703 D6EE
0704 D6EE
0705 D6EE              fst_scan Proc Export
0706 D6EE                       Import call_judgename,jn_parms:jn_parmBlock
0707 D6EE                       Import call_deref,call_alloc,call_lock_mem,call_unlock_mem
0708 D6EE                       Import fst_tbl,fst_count,entry_size,s_flags,id
0709 D6EE                       Import cp4_t2x_t3y,cp1_t2x_t3y
0710 D6EE
0711 D6EE                       with my_direct_page,fst_list_record
0712 D6EE                       with jn_parms
0713 D6EE
0714 D6EE A9 03 00              lda   #3                       ; initialize pCount for JudgeName calls
0715 D6F1 8F 81 B2 00           sta   >pCount
0716 D6F5
0717 D6F5 AF 0F B8 00           lda   >fst_count               ; probably in another bank
0718 D6F9 AA                    tax   
0719 D6FA A9 00 00              lda   #0
0720 D6FD
0721 D6FD              fst_scan_1  
0722 D6FD 69 20 00              adc   #ff_size                 ; computing fst struct size
0723 D700 CA                    dex                            ; = fst_count * ff_size
0724 D701 D0 FA                 bne   fst_scan_1
0725 D703
0726 D703 38                    sec   
0727 D704 22 00 D4 00           jsl   call_alloc
0728 D708 86 90                 stx   <fst_list_vp
0729 D70A 84 92                 sty   <fst_list_vp+2
0730 D70C 22 08 D4 00           jsl   call_deref
0731 D710 86 94                 stx   <fst_list_ptr
0732 D712 84 96                 sty   <fst_list_ptr+2
0733 D714
0734 D714 86 B2                 stx   <init_temp_3             ; pointer as I walk thru
0735 D716 84 B4                 sty   <init_temp_3+2           ; the new structure
0736 D718
0737 D718 64 9C                 stz   <fst_list_cnt            ; size of new structure
0738 D71A 64 AA                 stz   <init_temp_1             ; fst number currently processing
0739 D71C
0740 D71C A9 11 B8              lda   #<fst_tbl                ; pointer to src list
0741 D71F 85 B6                 sta   <init_temp_4
0742 D721 A9 00 00              lda   #^fst_tbl
0743 D724 85 B8                 sta   <init_temp_4+2
0744 D726
0745 D726 22 20 D4 00           jsl   call_lock_mem            ; lock the list down temporarily
0746 D72A
0747 D72A              ;  loop here for each FST in the table.  Temps usage:
0748 D72A              ;
0749 D72A              ;  init_temp_1.w = fst counter
0750 D72A              ;  init_temp_2   = pointer to fst header, current entry
0751 D72A              ;  init_temp_3   = pointer to my table, current entry
0752 D72A              ;  init_temp_4   = pointer to SCM's fst table, current entry
0753 D72A
0754 D72A              fst_scan_2  
0755 D72A A0 0E 00              ldy   #s_flags                 ; first- does it format?
0756 D72D B7 B6                 lda   [<init_temp_4],y
0757 D72F 29 00 20              and   #$2000                   ; *** check this field position
0758 D732 D0 03                 bne   @got_one
0759 D734 82 7F 00              brl   fst_scan_3               ; no format allowed this FST
0760 D737              @got_one  
0761 D737 A5 9C                 lda   <fst_list_cnt            ; ok.  write data into my record
0762 D739 A0 06 00              ldy   #ff_refnum               ; starting w/refnum
0763 D73C 97 B2                 sta   [<init_temp_3],y
0764 D73E
0765 D73E A0 0C 00              ldy   #id                      ; then file system #
0766 D741 B7 B6                 lda   [<init_temp_4],y
0767 D743 A0 08 00              ldy   #ff_fs_num
0768 D746 97 B2                 sta   [<init_temp_3],y
0769 D748 8F 83 B2 00           sta   >fileSysID               ; store into Parm Block for JudgeName call
0770 D74C
0771 D74C A7 B6                 lda   [<init_temp_4]           ; build ptr to actual header
0772 D74E 85 AE                 sta   <init_temp_2
0773 D750 A0 02 00              ldy   #2
0774 D753 B7 B6                 lda   [<init_temp_4],y
0775 D755 85 B0                 sta   <init_temp_2+2
0776 D757
0777 D757 A2 12 00              ldx   #18                      ; offset of fst block size
0778 D75A A0 0A 00              ldy   #ff_block_sz
0779 D75D 22 9F B2 00           jsl   cp1_t2x_t3y              ; copy 1 word + 2 longs
0780 D761 22 97 B2 00           jsl   cp4_t2x_t3y
0781 D765
0782 D765 A0 0E 00              ldy   #s_flags                 ; get the fst attributes again
0783 D768 B7 B6                 lda   [<init_temp_4],y
0784 D76A 29 03 00              and   #0003                    ; keeping lower 2 bits
0785 D76D A0 14 00              ldy   #ff_flags
0786 D770 97 B2                 sta   [<init_temp_3],y
0787 D772
0788 D772 F4 00 00              pea   call_judgename>>16
0789 D775 F4 36 B2              pea   call_judgename
0790 D778 F4 00 00              pea   0
0791 D77B 22 87 B1 00           jsl   >lc_dispatcher           ; call JudgeName to get the prompt pointer
0792 D77F
0793 D77F A0 1C 00              ldy   #ff_prompt               ; store prompt pointer into list member
0794 D782 AF 87 B2 00           lda   >syntax
0795 D786 97 B2                 sta   [<init_temp_3],y
0796 D788 A0 1E 00              ldy   #ff_prompt+2
0797 D78B AF 89 B2 00           lda   >syntax+2
0798 D78F 97 B2                 sta   [<init_temp_3],y
0799 D791
0800 D791 18                    clc   
0801 D792 A5 AE                 lda   <init_temp_2             ; build ptr to format name string
0802 D794 69 24 00              adc   #36
0803 D797 A0 00 00              ldy   #ff_mem_ptr
0804 D79A 97 B2                 sta   [<init_temp_3],y
0805 D79C C8                    iny   
0806 D79D C8                    iny   
0807 D79E A5 B0                 lda   <init_temp_2+2
0808 D7A0 69 00 00              adc   #0
0809 D7A3 97 B2                 sta   [<init_temp_3],y
0810 D7A5
0811 D7A5              ;  done with this entry.  Move to next entry of my table
0812 D7A5
0813 D7A5 18                    clc                            ; point to next entry
0814 D7A6 A5 B2                 lda   <init_temp_3
0815 D7A8 69 20 00              adc   #ff_size
0816 D7AB 85 B2                 sta   <init_temp_3
0817 D7AD A5 B4                 lda   <init_temp_3+2
0818 D7AF 69 00 00              adc   #0
0819 D7B2 85 B4                 sta   <init_temp_3+2
0820 D7B4
0821 D7B4 E6 9C                 inc   <fst_list_cnt
0822 D7B6
0823 D7B6              ;  after checking each fst, move to next fst
0824 D7B6
0825 D7B6              fst_scan_3  
0826 D7B6 18                    clc   
0827 D7B7 A5 B6                 lda   <init_temp_4
0828 D7B9 69 10 00              adc   #entry_size
0829 D7BC 85 B6                 sta   <init_temp_4
0830 D7BE A5 B8                 lda   <init_temp_4+2
0831 D7C0 69 00 00              adc   #0
0832 D7C3 85 B8                 sta   <init_temp_4+2
0833 D7C5
0834 D7C5 E6 AA                 inc   <init_temp_1             ; counter of fst's
0835 D7C7 A5 AA                 lda   <init_temp_1
0836 D7C9 CF 0F B8 00           cmp   >fst_count
0837 D7CD F0 03                 beq   fst_scan_4
0838 D7CF 82 58 FF              brl   fst_scan_2
0839 D7D2
0840 D7D2              ;  Did we find any?  (maybe we booted off of High Sierra and
0841 D7D2              ;   no ProDOS was available.  Unlikely but hey, who knows?)
0842 D7D2
0843 D7D2              fst_scan_4  
0844 D7D2 22 28 D4 00           jsl   call_unlock_mem          ; unlock memory
0845 D7D6 A9 00 00              lda   #0
0846 D7D9 C5 9C                 cmp   <fst_list_cnt            ; c set if =0
0847 D7DB 90 03                 bcc   fst_scan_5
0848 D7DD A9 65 00              lda   #invalid_fst_op
0849 D7E0              fst_scan_5  
0850 D7E0 6B                    rtl   
0851 D7E1                       EndP 
0852 D7E1
0853 D7E1                       END   
